/*           Schema x_10_interfaces              */

CREATE SCHEMA IF NOT EXISTS x_10_interfaces;


/*           Tabellen                            */

CREATE TABLE IF NOT EXISTS x_10_interfaces.nexar_mapping (
  nexm_id               SERIAL        PRIMARY KEY,
  nexm_mapping_typ      varchar(30)   NOT NULL,  -- Art der Zuordnung (Eigenschaft/Eingabefeld)
  nexm_table            regclass,                -- Zieltabelle Prodat
  nexm_column           varchar(100),            -- Zielfeld Prodat
  nexm_reg_pname        varchar(40),             -- Zielparameter
  nexm_txt              text,                    -- zu übernehmender Text
  nexm_cast             varchar(50),             -- frei definierbarer Datentyp
  nexm_where            text                     -- frei definierbarer Where-Teil
 );

CREATE TABLE IF NOT EXISTS x_10_interfaces.nexar_api_call (
  nex_id               serial       PRIMARY KEY,
  nex_api              text         NOT NULL,  -- Nexar Anfrage-Query
  nex_ownerform        varchar(100)            -- Prodat Form
 );

CREATE TABLE IF NOT EXISTS x_10_interfaces.interfaces_import (
  ii_id               SERIAL        PRIMARY KEY,
  ii_connector        varchar(20)   NOT NULL,  -- Anbindung (z.B. Nexar)
  ii_ownerform        varchar(100),            -- Prodat Form
  ii_ownerform_var    json,                    -- Prodat Variablen
  ii_api_call         text          NOT null,  -- Anfrage-Query
  ii_api_call_var     json,                    -- zusätzliche Variablen
  ii_result           json          NOT null   -- Ergebnis
 );


/*           Trigger                              */

CREATE OR REPLACE FUNCTION x_10_interfaces.nexar_mapping__biu__cast__into_nexm_cast()
   RETURNS TRIGGER AS $$
   BEGIN

    IF new.nexm_mapping_typ = 'Parameter' THEN
      -- Wenn ein Paratmeter definiert wird, dann soll der r_value korrekt gecastet werden
      new.nexm_cast := coalesce( ( SELECT pt_dbtyp
                                    FROM recnogroup
                                    JOIN TRecnoParam.SupportedTypes() ON pt_typ = reg_paramtype
                                    WHERE reg_pname = new.nexm_reg_pname )
                                  ,
                                  new.nexm_cast );

    ELSIF new.nexm_mapping_typ = 'Eingabefeld' THEN
      -- Wenn ein Eingabefeld definiert wird, dann soll der der Text korrekt gecastet werden
      new.nexm_cast := coalesce( ( SELECT data_type
                                     FROM information_schema.columns
                                     LEFT JOIN ( SELECT replace(unnest, '"$user"', CURRENT_USER ) AS schema,
                                                       row_number() OVER () AS rank_number
                                                  FROM unnest( string_to_array( ( SELECT setting FROM pg_settings WHERE name = 'search_path' ), ',' ) )
                                                ) AS search_path ON search_path.schema = table_schema
                                    WHERE table_name = new.nexm_table::varchar
                                      AND column_name = new.nexm_column::varchar
                                    ORDER BY rank_number ASC
                                    LIMIT 1 )
                                  ,
                                  new.nexm_cast );
    END IF;

    RETURN new;

  END $$ LANGUAGE plpgsql;

CREATE TRIGGER nexar_mapping__biu__cast__into_nexm_cast
    BEFORE INSERT OR UPDATE
    OF nexm_reg_pname, nexm_table, nexm_column, nexm_mapping_typ
    ON x_10_interfaces.nexar_mapping
    FOR EACH ROW
    EXECUTE PROCEDURE x_10_interfaces.nexar_mapping__biu__cast__into_nexm_cast();